/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.filesystem.s3;

import com.amazon.s3.AWSAuthConnection;
import com.amazon.s3.Bucket;
import com.amazon.s3.CallingFormat;
import com.amazon.s3.ListAllMyBucketsResponse;
import com.amazon.s3.ListBucketResponse;
import com.amazon.s3.ListEntry;
import com.amazon.s3.Response;
import com.aptana.core.util.FileUtil;
import com.aptana.core.util.IOUtil;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.filesystem.s3.Messages;
import com.aptana.ide.filesystem.s3.Policy;
import com.aptana.ide.filesystem.s3.S3FileSystemPlugin;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class S3FileStore
extends FileStore {
    private static final String DATE_FORMAT = "EEE, d MMM yyyy HH:mm:ss z";
    private static final String LAST_MODIFIED = "Last-Modified";
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String SEPARATOR = "/";
    private static final String FOLDER_SUFFIX = "_$folder$";
    private URI uri;
    private Path path;
    private String accessKey;

    protected S3FileStore(URI uri) {
        this.uri = uri;
        this.path = new Path(uri.getPath().replaceAll("%2F", SEPARATOR));
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        return this.childNames(options, false, monitor);
    }

    private String[] childNames(int options, boolean includeHackFolderFiles, IProgressMonitor monitor) throws CoreException {
        try {
            if (this.isRoot()) {
                return this.getBuckets();
            }
            String prefix = this.getPrefix();
            List<ListEntry> entries = this.listEntries();
            ArrayList<String> keys = new ArrayList<String>();
            if (entries == null) {
                return keys.toArray(new String[0]);
            }
            for (ListEntry entry : entries) {
                if (prefix.length() >= entry.key.length()) continue;
                try {
                    String relative = entry.key.substring(prefix.length());
                    if (prefix.length() == 0 || relative.startsWith(SEPARATOR)) {
                        int index;
                        if (prefix.length() > 0) {
                            relative = relative.substring(1);
                        }
                        if ((index = relative.indexOf(SEPARATOR)) != -1) {
                            relative = relative.substring(0, index);
                        } else if (relative.endsWith(FOLDER_SUFFIX)) {
                            relative = relative.substring(0, relative.length() - FOLDER_SUFFIX.length());
                        }
                    } else if (!relative.equals(FOLDER_SUFFIX) || !includeHackFolderFiles) continue;
                    if (relative.length() == 0 || keys.contains(relative)) continue;
                    keys.add(relative);
                }
                catch (Exception e) {
                    S3FileSystemPlugin.log(e);
                }
            }
            return keys.toArray(new String[keys.size()]);
        }
        catch (MalformedURLException e) {
            throw S3FileSystemPlugin.coreException(e);
        }
        catch (IOException e) {
            throw S3FileSystemPlugin.coreException(e);
        }
    }

    private String[] getBuckets() throws MalformedURLException, IOException {
        ArrayList<String> keys = new ArrayList<String>();
        ListAllMyBucketsResponse resp = this.getAWSConnection().listAllMyBuckets(null);
        if (resp == null || resp.entries == null) {
            return keys.toArray(new String[0]);
        }
        List buckets = resp.entries;
        for (Bucket bucket : buckets) {
            keys.add(bucket.name);
        }
        return keys.toArray(new String[keys.size()]);
    }

    private boolean isRoot() {
        return this.getBucket() == null;
    }

    private String getPrefix() {
        String prefix = this.path.removeFirstSegments(1).toPortableString();
        if (prefix.startsWith(SEPARATOR)) {
            prefix = prefix.substring(1);
        }
        return prefix;
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        FileInfo info;
        block14: {
            info = new FileInfo(this.getName());
            if (this.path.isRoot()) {
                info.setExists(true);
                info.setDirectory(true);
                info.setAttribute(0x1000000, true);
                info.setAttribute(0x8000000, true);
            } else {
                if (this.isBucket()) {
                    try {
                        boolean exists = this.getAWSConnection().checkBucketExists(this.getBucket());
                        info.setExists(exists);
                        info.setDirectory(true);
                        info.setAttribute(0x1000000, true);
                    }
                    catch (IOException e) {
                        throw S3FileSystemPlugin.coreException(e);
                    }
                }
                try {
                    HttpURLConnection connection = this.getAWSConnection().head(this.getBucket(), this.getKey(), null);
                    if (connection.getResponseCode() < 400) {
                        info.setExists(true);
                        info.setDirectory(false);
                        String length = connection.getHeaderField(CONTENT_LENGTH);
                        if (length != null) {
                            info.setLength(Long.parseLong(length));
                        }
                        try {
                            String lastModified = connection.getHeaderField(LAST_MODIFIED);
                            if (lastModified != null) {
                                Date date = new SimpleDateFormat(DATE_FORMAT).parse(lastModified);
                                info.setLastModified(date.getTime());
                            }
                            break block14;
                        }
                        catch (ParseException parseException) {}
                        break block14;
                    }
                    String[] children = this.childNames(options, true, monitor);
                    if (children != null && children.length > 0) {
                        info.setDirectory(true);
                        info.setExists(true);
                        info.setLastModified(System.currentTimeMillis());
                        info.setLength(0L);
                        info.setAttribute(0x1000000, true);
                    }
                }
                catch (MalformedURLException e) {
                    throw S3FileSystemPlugin.coreException(e);
                }
                catch (IOException e) {
                    throw S3FileSystemPlugin.coreException(e);
                }
            }
        }
        return info;
    }

    private boolean isBucket() {
        return this.getKey() == null || this.getKey().length() == 0;
    }

    public IFileStore getChild(String name) {
        try {
            IPath childPath = this.path.append(name);
            if (!childPath.isAbsolute()) {
                childPath = childPath.makeAbsolute();
            }
            return new S3FileStore(this.getURI(childPath));
        }
        catch (URISyntaxException e) {
            S3FileSystemPlugin.log(e);
            return null;
        }
    }

    private URI getURI(IPath childPath) throws URISyntaxException {
        return new URI(this.uri.getScheme(), this.uri.getUserInfo(), this.uri.getHost(), this.uri.getPort(), childPath.toPortableString(), this.uri.getQuery(), this.uri.getFragment());
    }

    public String getName() {
        return this.path.segmentCount() == 0 ? this.path.toPortableString() : this.path.lastSegment();
    }

    public IFileStore getParent() {
        if (this.path.segmentCount() == 0) {
            return null;
        }
        try {
            IPath parentPath = this.path.removeLastSegments(1);
            return new S3FileStore(this.getURI(parentPath));
        }
        catch (URISyntaxException e) {
            S3FileSystemPlugin.log(e);
            return null;
        }
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        try {
            HttpURLConnection connection = this.getAWSConnection().getRaw(this.getBucket(), this.getKey(), null);
            int responseCode = connection.getResponseCode();
            if (responseCode == 404) {
                throw S3FileSystemPlugin.coreException(269, new FileNotFoundException(this.path.toPortableString()));
            }
            if (responseCode < 400) {
                return connection.getInputStream();
            }
            throw S3FileSystemPlugin.coreException(566, new Exception(this.errorMessage(responseCode, connection)));
        }
        catch (MalformedURLException e) {
            throw S3FileSystemPlugin.coreException(e);
        }
        catch (IOException e) {
            throw S3FileSystemPlugin.coreException(e);
        }
    }

    AWSAuthConnection getAWSConnection() {
        boolean secure = true;
        if (this.getBucket() != null && this.getBucket().indexOf(".") != -1) {
            secure = false;
        }
        return new AWSAuthConnection(this.getAccessKey(), this.getSecretAccessKey(), secure, this.uri.getHost(), CallingFormat.getPathCallingFormat());
    }

    private char[] promptPassword(String title, String message) {
        char[] password = CoreIOPlugin.getAuthenticationManager().promptPassword(this.getAuthId(), this.getAccessKey(), title, message);
        if (password == null) {
            password = new char[]{};
            throw new OperationCanceledException();
        }
        return password;
    }

    private char[] getOrPromptPassword(String title, String message) {
        char[] password = CoreIOPlugin.getAuthenticationManager().getPassword(this.getAuthId());
        if (password == null) {
            password = new char[]{};
            this.promptPassword(title, message);
        }
        return password;
    }

    private String getAuthId() {
        return Policy.generateAuthId("s3", this.getAccessKey(), this.uri.getHost());
    }

    private String getSecretAccessKey() {
        String userInfo = this.uri.getUserInfo();
        if (userInfo.contains(":")) {
            return userInfo.split(":")[1];
        }
        return new String(this.getOrPromptPassword(MessageFormat.format(Messages.S3FileStore_Authentication, this.getAccessKey()), Messages.S3FileStore_EnterAccessKey));
    }

    private synchronized String getAccessKey() {
        if (this.accessKey == null) {
            String userInfo = this.uri.getUserInfo();
            this.accessKey = userInfo.contains(":") ? userInfo.split(":")[0] : userInfo;
        }
        return this.accessKey;
    }

    String getKey() {
        String key = this.path.removeFirstSegments(1).toPortableString();
        if (key.startsWith(SEPARATOR) && key.length() > 1) {
            return key.substring(1);
        }
        return key;
    }

    private String getBucket() {
        if (this.path.segmentCount() == 0) {
            return null;
        }
        return this.path.segment(0);
    }

    public URI toURI() {
        return this.uri;
    }

    public void delete(int options, IProgressMonitor monitor) throws CoreException {
        try {
            IFileStore[] children;
            IFileStore[] iFileStoreArray = children = this.childStores(options, monitor);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore child = iFileStoreArray[n2];
                child.delete(options, monitor);
                ++n2;
            }
            int responseCode = 0;
            if (this.isBucket()) {
                Response resp = this.getAWSConnection().deleteBucket(this.getBucket(), null);
                responseCode = resp.connection.getResponseCode();
            } else {
                String key = this.getKey();
                Response resp = this.getAWSConnection().delete(this.getBucket(), key, null);
                responseCode = resp.connection.getResponseCode();
                resp = this.getAWSConnection().delete(this.getBucket(), String.valueOf(key) + FOLDER_SUFFIX, null);
                resp.connection.getResponseCode();
            }
            if (responseCode < 400) {
                return;
            }
            throw S3FileSystemPlugin.coreException(273, new Exception(this.path.toPortableString()));
        }
        catch (MalformedURLException e) {
            throw S3FileSystemPlugin.coreException(e);
        }
        catch (IOException e) {
            throw S3FileSystemPlugin.coreException(e);
        }
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        try {
            if (this.isBucket()) {
                throw S3FileSystemPlugin.coreException(279, new Exception("Can't write to a bucket!"));
            }
            IFileStore parent = this.getParent();
            IFileInfo info = parent.fetchInfo();
            if (!info.exists()) {
                throw S3FileSystemPlugin.coreException(272, new FileNotFoundException(this.path.toPortableString()));
            }
            HttpURLConnection connection = this.getAWSConnection().putRaw(this.getBucket(), this.getKey(), null);
            return new HttpForcingOutputStream(connection.getOutputStream(), connection);
        }
        catch (MalformedURLException e) {
            throw S3FileSystemPlugin.coreException(e);
        }
        catch (IOException e) {
            throw S3FileSystemPlugin.coreException(e);
        }
    }

    public IFileStore mkdir(int options, IProgressMonitor monitor) throws CoreException {
        try {
            HttpURLConnection connection = null;
            if (this.isBucket()) {
                Response resp = this.getAWSConnection().createBucket(this.getBucket(), null, null);
                connection = resp.connection;
            } else {
                if ((options & 4) != 0) {
                    IFileStore parent = this.getParent();
                    IFileInfo info = parent.fetchInfo();
                    if (!info.exists()) {
                        throw S3FileSystemPlugin.coreException(566, Messages.S3FileStore_ParentNotExist, new FileNotFoundException(this.path.toPortableString()));
                    }
                    if (!info.isDirectory()) {
                        throw S3FileSystemPlugin.coreException(566, Messages.S3FileStore_ParentNotADirectory, new FileNotFoundException(this.path.toPortableString()));
                    }
                }
                connection = this.getAWSConnection().putRaw(this.getBucket(), String.valueOf(this.getKey()) + FOLDER_SUFFIX, null);
                connection.getOutputStream().write(new byte[0]);
            }
            int responseCode = connection.getResponseCode();
            if (responseCode >= 400) {
                throw S3FileSystemPlugin.coreException(566, new Exception(this.errorMessage(responseCode, connection)));
            }
        }
        catch (MalformedURLException e) {
            throw S3FileSystemPlugin.coreException(e);
        }
        catch (IOException e) {
            throw S3FileSystemPlugin.coreException(e);
        }
        return this;
    }

    private String errorMessage(int responseCode, HttpURLConnection connection) throws CoreException {
        String msg = "";
        try {
            msg = IOUtil.read((InputStream)connection.getErrorStream());
            int index = msg.indexOf("<Message>");
            if (index != -1) {
                msg = msg.substring(index + 9);
            }
            if ((index = msg.indexOf("</Message>")) != -1) {
                msg = msg.substring(0, index);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return MessageFormat.format("({0}) {1}", responseCode, msg);
    }

    public void putInfo(IFileInfo info, int options, IProgressMonitor monitor) throws CoreException {
    }

    public File toLocalFile(int options, IProgressMonitor monitor) throws CoreException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (options == 4096) {
            try {
                File result;
                IFileInfo myInfo = this.fetchInfo(0, (IProgressMonitor)sub.newChild(25));
                if (!myInfo.exists()) {
                    result = File.createTempFile("Non-Existent-", Long.toString(System.currentTimeMillis()));
                } else {
                    if (myInfo.isDirectory()) {
                        File tmpDir = FileUtil.getTempDirectory().toFile();
                        result = this.getUniqueDirectory(tmpDir);
                    } else {
                        result = File.createTempFile("s3file", "efs");
                    }
                    sub.worked(25);
                    IFileStore resultStore = EFS.getLocalFileSystem().fromLocalFile(result);
                    this.copy(resultStore, 2, (IProgressMonitor)sub.newChild(25));
                }
                result.deleteOnExit();
                return result;
            }
            catch (IOException e) {
                throw S3FileSystemPlugin.coreException(272, e);
            }
        }
        return super.toLocalFile(options, monitor);
    }

    private File getUniqueDirectory(File parent) {
        File dir;
        long i = 0L;
        while ((dir = new File(parent, Long.toString(System.currentTimeMillis() + i++))).exists()) {
        }
        return dir;
    }

    protected void copyFile(IFileInfo sourceInfo, IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        if (destination instanceof S3FileStore) {
            IFileInfo destInfo;
            S3FileStore s3Dest = (S3FileStore)destination;
            if ((options & 2) == 0 && (destInfo = destination.fetchInfo()).exists()) {
                throw S3FileSystemPlugin.coreException(566, Messages.S3FileStore_DestinationExists, new FileNotFoundException(s3Dest.path.toPortableString()));
            }
            IFileStore parent = destination.getParent();
            IFileInfo info = parent.fetchInfo();
            if (!info.exists()) {
                throw S3FileSystemPlugin.coreException(566, Messages.S3FileStore_ParentNotExist, new FileNotFoundException(s3Dest.path.toPortableString()));
            }
            if (!info.isDirectory()) {
                throw S3FileSystemPlugin.coreException(566, Messages.S3FileStore_ParentNotADirectory, new FileNotFoundException(s3Dest.path.toPortableString()));
            }
            try {
                this.getAWSConnection().copy(this.getBucket(), this.getKey(), s3Dest.getBucket(), s3Dest.getKey(), null);
            }
            catch (MalformedURLException e) {
                throw S3FileSystemPlugin.coreException(566, e);
            }
            catch (IOException e) {
                throw S3FileSystemPlugin.coreException(566, e);
            }
        } else {
            super.copyFile(sourceInfo, destination, options, monitor);
        }
    }

    List<ListEntry> listEntries() throws MalformedURLException, IOException {
        String prefix = this.getPrefix();
        if (prefix != null && prefix.trim().length() == 0) {
            prefix = null;
        }
        ListBucketResponse resp = this.getAWSConnection().listBucket(this.getBucket(), prefix, null, null, null);
        return resp.entries;
    }

    public void move(IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            this.copy(destination, options, (IProgressMonitor)sub.newChild(70));
            this.delete(0, (IProgressMonitor)sub.newChild(30));
        }
        finally {
            sub.done();
        }
    }

    protected void copyDirectory(IFileInfo sourceInfo, IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        IFileInfo destInfo;
        if ((options & 2) == 0 && (destInfo = destination.fetchInfo()).exists()) {
            throw S3FileSystemPlugin.coreException(268, new FileNotFoundException(destination.toURI().getPath()));
        }
        IFileStore destParent = destination.getParent();
        IFileInfo fi = destParent.fetchInfo();
        if (!fi.exists()) {
            throw S3FileSystemPlugin.coreException(272, new FileNotFoundException(destination.toURI().getPath()));
        }
        super.copyDirectory(sourceInfo, destination, options, monitor);
    }

    private static class HttpForcingOutputStream
    extends OutputStream {
        private OutputStream out;
        private HttpURLConnection connection;

        HttpForcingOutputStream(OutputStream out, HttpURLConnection connection) {
            this.out = out;
            this.connection = connection;
        }

        public void write(int b) throws IOException {
            this.out.write(b);
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public void close() throws IOException {
            this.out.close();
            this.connection.getResponseCode();
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        public void write(byte[] b) throws IOException {
            this.out.write(b);
        }
    }
}

